package gov.va.caret.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

import java.util.Calendar;
import java.util.Date;

public class BusinessDayUtil {

	private static Log _log = LogFactoryUtil.getLog( BusinessDayUtil.class );

	public static boolean isWeekend(Calendar calendar)
	{		
		boolean isWeekend = false;
		
		if(calendar.get(Calendar.DAY_OF_WEEK)==1 || calendar.get(Calendar.DAY_OF_WEEK)==7){
			isWeekend = true;
		}
				
		return isWeekend;
	}	
	
	public static boolean isHoliday(Calendar calendar){
		
		boolean isHoliday = false;
		
		if(Toolbox.getDateFormatCprs().format(calendar.getTime()).equals(Toolbox.getDateFormatCprs().format(NewYearsDay(calendar.get(Calendar.YEAR))))){
			_log.debug("Date is New Year - "+Toolbox.getDateFormatCprs().format(calendar.getTime()));
			isHoliday = true;
		}else if(Toolbox.getDateFormatCprs().format(calendar.getTime()).equals(Toolbox.getDateFormatCprs().format(MLKDay(calendar.get(Calendar.YEAR))))){
			_log.debug("Date is MLK Day - "+Toolbox.getDateFormatCprs().format(calendar.getTime()));
			isHoliday = true;
		}else if(Toolbox.getDateFormatCprs().format(calendar.getTime()).equals(Toolbox.getDateFormatCprs().format(PresidentDay(calendar.get(Calendar.YEAR))))){
			_log.debug("Date is President Day - "+Toolbox.getDateFormatCprs().format(calendar.getTime()));
			isHoliday = true;
		}else if(Toolbox.getDateFormatCprs().format(calendar.getTime()).equals(Toolbox.getDateFormatCprs().format(MemorialDay(calendar.get(Calendar.YEAR))))){
			_log.debug("Date is Memorial Day - "+Toolbox.getDateFormatCprs().format(calendar.getTime()));
			isHoliday = true;
		}else if(Toolbox.getDateFormatCprs().format(calendar.getTime()).equals(Toolbox.getDateFormatCprs().format(IndependenceDay(calendar.get(Calendar.YEAR))))){
			_log.debug("Date is Independence Day - "+Toolbox.getDateFormatCprs().format(calendar.getTime()));
			isHoliday = true;
		}else if(Toolbox.getDateFormatCprs().format(calendar.getTime()).equals(Toolbox.getDateFormatCprs().format(LaborDay(calendar.get(Calendar.YEAR))))){
			_log.debug("Date is Labor Day - "+Toolbox.getDateFormatCprs().format(calendar.getTime()));
			isHoliday = true;
		}else if(Toolbox.getDateFormatCprs().format(calendar.getTime()).equals(Toolbox.getDateFormatCprs().format(ColumbusDay(calendar.get(Calendar.YEAR))))){
			_log.debug("Date is Columbus Day - "+Toolbox.getDateFormatCprs().format(calendar.getTime()));
			isHoliday = true;
		}else if(Toolbox.getDateFormatCprs().format(calendar.getTime()).equals(Toolbox.getDateFormatCprs().format(VeteransDay(calendar.get(Calendar.YEAR))))){
			_log.debug("Date is Veterans Day - "+Toolbox.getDateFormatCprs().format(calendar.getTime()));
			isHoliday = true;
		}else if(Toolbox.getDateFormatCprs().format(calendar.getTime()).equals(Toolbox.getDateFormatCprs().format(ThanksgivingDay(calendar.get(Calendar.YEAR))))){
			_log.debug("Date is Thanksgiving Day - "+Toolbox.getDateFormatCprs().format(calendar.getTime()));
			isHoliday = true;
		}else if(Toolbox.getDateFormatCprs().format(calendar.getTime()).equals(Toolbox.getDateFormatCprs().format(ChristmasDay(calendar.get(Calendar.YEAR))))){
			_log.debug("Date is Christmas Day - "+Toolbox.getDateFormatCprs().format(calendar.getTime()));
			isHoliday = true;
		}

		return isHoliday;
	}
	
	
	public static Date NewYearsDay(int nYear)
    {    	
    	//New Year Day - 1 Jan
	    Calendar calendar = Calendar.getInstance();
	    calendar.set(Calendar.MONTH, 0);
	    calendar.set(Calendar.YEAR, nYear);
	    calendar.set(Calendar.DAY_OF_MONTH, 1);
	    		
	    int dayOfWeek = calendar.get(Calendar.DAY_OF_WEEK);
	    switch(dayOfWeek)
	    {
	      case 1 : // Sunday
	      { calendar.set(Calendar.DAY_OF_MONTH, 2); break; }
	      case 2 : // Monday
	      case 3 : // Tuesday
	      case 4 : // Wednesday
	      case 5 : // Thursday
	      case 6 : // Friday
	      { break; }
	      default :
	      {
		      // Saturday, then observe on friday of previous year	        	
	    	  calendar.set(Calendar.MONTH, 11);
	    	  calendar.set(Calendar.YEAR, --nYear);
	    	  calendar.set(Calendar.DAY_OF_MONTH, 31);
	      }
	    }

        return calendar.getTime();	        	
	}

    public static Date MLKDay(int nYear)
    {    	
    	//MLK Day - Third Monday in Jan
	    Calendar calendar = Calendar.getInstance();
	    calendar.set(Calendar.MONTH, 0);
	    calendar.set(Calendar.YEAR, nYear);
	    calendar.set(Calendar.DAY_OF_MONTH, 1);
	    		
	    int dayOfWeek = calendar.get(Calendar.DAY_OF_WEEK);
	    switch(dayOfWeek)
	    {
		  case 1 : // Sunday
		  { calendar.set(Calendar.DAY_OF_MONTH, 16); break; }	      
		  case 2 : // Monday
		  { calendar.set(Calendar.DAY_OF_MONTH, 15); break; }
		  case 3 : // Tuesday
		  { calendar.set(Calendar.DAY_OF_MONTH, 21); break; }
		  case 4 : // Wednesday
		  { calendar.set(Calendar.DAY_OF_MONTH, 20); break; }
		  case 5 : // Thursday
		  { calendar.set(Calendar.DAY_OF_MONTH, 19); break; }
		  case 6 : // Friday
		  { calendar.set(Calendar.DAY_OF_MONTH, 18); break; }
		  default : // Saturday
		  { calendar.set(Calendar.DAY_OF_MONTH, 17); }
	    }

        return calendar.getTime();        	
	}
	
    public static Date PresidentDay(int nYear)
    {    	
		//3. President Day - Third Monday in Feb
	    Calendar calendar = Calendar.getInstance();
	    calendar.set(Calendar.MONTH, 1);
	    calendar.set(Calendar.YEAR, nYear);
	    calendar.set(Calendar.DAY_OF_MONTH, 1);
	    		
	    int dayOfWeek = calendar.get(Calendar.DAY_OF_WEEK);
	    switch(dayOfWeek)
	    {
	      case 1 : // Sunday
	      { calendar.set(Calendar.DAY_OF_MONTH, 16); break; }	      
          case 2 : // Monday
	      { calendar.set(Calendar.DAY_OF_MONTH, 15); break; }
          case 3 : // Tuesday
	      { calendar.set(Calendar.DAY_OF_MONTH, 21); break; }
          case 4 : // Wednesday
	      { calendar.set(Calendar.DAY_OF_MONTH, 20); break; }
          case 5 : // Thursday
	      { calendar.set(Calendar.DAY_OF_MONTH, 19); break; }
          case 6 : // Friday
	      { calendar.set(Calendar.DAY_OF_MONTH, 18); break; }
          default : // Saturday
	      { calendar.set(Calendar.DAY_OF_MONTH, 17); }
	    }

        return calendar.getTime();        	
	}
    
    public static Date MemorialDay(int nYear)
    {    	
		//Memorial Day - Last Monday in May
	    Calendar calendar = Calendar.getInstance();
	    calendar.set(Calendar.MONTH, 4);
	    calendar.set(Calendar.YEAR, nYear);
	    calendar.set(Calendar.DAY_OF_MONTH, 31);
	    		
	    int dayOfWeek = calendar.get(Calendar.DAY_OF_WEEK);
	    switch(dayOfWeek)
	    {
	      case 1 : // Sunday
	      { calendar.set(Calendar.DAY_OF_MONTH, 25); break; }	      
          case 2 : // Monday
	      { calendar.set(Calendar.DAY_OF_MONTH, 31); break; }
          case 3 : // Tuesday
	      { calendar.set(Calendar.DAY_OF_MONTH, 30); break; }
          case 4 : // Wednesday
	      { calendar.set(Calendar.DAY_OF_MONTH, 29); break; }
          case 5 : // Thursday
	      { calendar.set(Calendar.DAY_OF_MONTH, 28); break; }
          case 6 : // Friday
	      { calendar.set(Calendar.DAY_OF_MONTH, 27); break; }
          default : // Saturday
	      { calendar.set(Calendar.DAY_OF_MONTH, 26); }
	    }

        return calendar.getTime();        	
	}
    
    public static Date IndependenceDay(int nYear)
    {    	
		//Independence Day - 4 July
	    Calendar calendar = Calendar.getInstance();
	    calendar.set(Calendar.MONTH, 6);
	    calendar.set(Calendar.YEAR, nYear);
	    calendar.set(Calendar.DAY_OF_MONTH, 4);
	    		
	    int dayOfWeek = calendar.get(Calendar.DAY_OF_WEEK);
	    switch(dayOfWeek)
	    {
	      case 1 : // Sunday
	      { calendar.set(Calendar.DAY_OF_MONTH, 5); break; }	      
	      case 2 : // Monday
	      case 3 : // Tuesday
	      case 4 : // Wednesday
	      case 5 : // Thursday
	      case 6 : // Friday
		  { break; }
	      default : // Saturday
		  { calendar.set(Calendar.DAY_OF_MONTH, 3);}
	    }
 
        return calendar.getTime();        	
	}
    
    public static Date LaborDay(int nYear)
    {    
		//Labor Day - First Monday in Sep
	    Calendar calendar = Calendar.getInstance();
	    calendar.set(Calendar.MONTH, 8);
	    calendar.set(Calendar.YEAR, nYear);
	    calendar.set(Calendar.DAY_OF_MONTH, 1);
	    		
	    int dayOfWeek = calendar.get(Calendar.DAY_OF_WEEK);
	    switch(dayOfWeek)
	    {
	      case 1 : // Sunday
	      { calendar.set(Calendar.DAY_OF_MONTH, 2); break; }	      
          case 2 : // Monday
	      { calendar.set(Calendar.DAY_OF_MONTH, 1); break; }
          case 3 : // Tuesday
	      { calendar.set(Calendar.DAY_OF_MONTH, 7); break; }
          case 4 : // Wednesday
	      { calendar.set(Calendar.DAY_OF_MONTH, 6); break; }
          case 5 : // Thursday
	      { calendar.set(Calendar.DAY_OF_MONTH, 5); break; }
          case 6 : // Friday
	      { calendar.set(Calendar.DAY_OF_MONTH, 4); break; }
          default : // Saturday
	      { calendar.set(Calendar.DAY_OF_MONTH, 3); }
	    }
 
        return calendar.getTime();        	
	}   

    public static Date ColumbusDay(int nYear)
    {    	
		//Columbus Day - Second Monday in Oct
	    Calendar calendar = Calendar.getInstance();
	    calendar.set(Calendar.MONTH, 9);
	    calendar.set(Calendar.YEAR, nYear);
	    calendar.set(Calendar.DAY_OF_MONTH, 1);
	    		
	    int dayOfWeek = calendar.get(Calendar.DAY_OF_WEEK);
	    switch(dayOfWeek)
	    {
	      case 1 : // Sunday
	      { calendar.set(Calendar.DAY_OF_MONTH, 9); break; }	      
          case 2 : // Monday
	      { calendar.set(Calendar.DAY_OF_MONTH, 8); break; }
          case 3 : // Tuesday
	      { calendar.set(Calendar.DAY_OF_MONTH, 14); break; }
          case 4 : // Wednesday
	      { calendar.set(Calendar.DAY_OF_MONTH, 13); break; }
          case 5 : // Thursday
	      { calendar.set(Calendar.DAY_OF_MONTH, 12); break; }
          case 6 : // Friday
	      { calendar.set(Calendar.DAY_OF_MONTH, 11); break; }
          default : // Saturday
	      { calendar.set(Calendar.DAY_OF_MONTH, 10); }
	    }
 
        return calendar.getTime();        	
	} 

    public static Date VeteransDay(int nYear)
    {    
    	// Veterans Day - 11 Nov
	    Calendar calendar = Calendar.getInstance();
	    calendar.set(Calendar.MONTH, 10);
	    calendar.set(Calendar.YEAR, nYear);
	    calendar.set(Calendar.DAY_OF_MONTH, 11);
	    		
	    int dayOfWeek = calendar.get(Calendar.DAY_OF_WEEK);
	    switch(dayOfWeek)
	    {
	      case 1 : // Sunday
	      { calendar.set(Calendar.DAY_OF_MONTH, 12); break; }	      
	      case 2 : // Monday
	      case 3 : // Tuesday
	      case 4 : // Wednesday
	      case 5 : // Thursday
	      case 6 : // Friday
		  { break; }
	      default : // Saturday
		  { calendar.set(Calendar.DAY_OF_MONTH, 10);}
	    }
 
        return calendar.getTime();        	
	}

    public static Date ThanksgivingDay(int nYear)
    {    	
    	//Thanksgiving - Fourth Thursday in Nov
	    Calendar calendar = Calendar.getInstance();
	    calendar.set(Calendar.MONTH, 10);
	    calendar.set(Calendar.YEAR, nYear);
	    calendar.set(Calendar.DAY_OF_MONTH, 1);
	    		
	    int dayOfWeek = calendar.get(Calendar.DAY_OF_WEEK);
	    switch(dayOfWeek)
	    {
	      case 1 : // Sunday
	      { calendar.set(Calendar.DAY_OF_MONTH, 26); break; }	      
          case 2 : // Monday
	      { calendar.set(Calendar.DAY_OF_MONTH, 25); break; }
          case 3 : // Tuesday
	      { calendar.set(Calendar.DAY_OF_MONTH, 24); break; }
          case 4 : // Wednesday
	      { calendar.set(Calendar.DAY_OF_MONTH, 23); break; }
          case 5 : // Thursday
	      { calendar.set(Calendar.DAY_OF_MONTH, 22); break; }
          case 6 : // Friday
	      { calendar.set(Calendar.DAY_OF_MONTH, 28); break; }
          default : // Saturday
	      { calendar.set(Calendar.DAY_OF_MONTH, 27); }
	    }
 
        return calendar.getTime();        	
	}

    public static Date ChristmasDay(int nYear)
    {    	
    	//Christmas Day - 25 December
	    Calendar calendar = Calendar.getInstance();
	    calendar.set(Calendar.MONTH, 11);
	    calendar.set(Calendar.YEAR, nYear);
	    calendar.set(Calendar.DAY_OF_MONTH, 25);
	    		
	    int dayOfWeek = calendar.get(Calendar.DAY_OF_WEEK);
	    switch(dayOfWeek)
	    {
	      case 1 : // Sunday
	      { calendar.set(Calendar.DAY_OF_MONTH, 26); break; }	      
	      case 2 : // Monday
	      case 3 : // Tuesday
	      case 4 : // Wednesday
	      case 5 : // Thursday
	      case 6 : // Friday
		  { break; }
	      default : // Saturday
		  { calendar.set(Calendar.DAY_OF_MONTH, 24);}
	    }
 
        return calendar.getTime();        	
	}
}
